/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Immediate;

public class ANC
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        int accu_old = (int)cpu.getAccu().getNumber();
        Flags6502 flags = cpu.getFlags();
        int accu = accu_old & (int)operand.getByte().getNumber();
        flags.setNZFromValue(accu);
        flags.setCarry(flags.getNegative());
        cpu.setAccu(new HwByte((long)accu));
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "ANC";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(43, this, new Immediate());
        cset.defineCommand(11, this, new Immediate());
    }
}

